
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[P_DASHBOARD_VENDAS_DESCONTOS_FILIAL]') AND type in (N'P', N'PC'))
begin
DROP PROCEDURE [dbo].[P_DASHBOARD_VENDAS_DESCONTOS_FILIAL]
end
GO




--EXEC P_DASHBOARD_VENDAS_DESCONTOS_FILIAL 1,'1','20180101','20180110'
CREATE PROCEDURE [dbo].[P_DASHBOARD_VENDAS_DESCONTOS_FILIAL] (@CD_EMP INT, @CD_FILIAL VARCHAR(MAX)='',@DT_INI DATETIME, @DT_FIM DATETIME)
AS
CREATE TABLE #_RS_FILIAL (CD_EMP INT, CD_FILIAL	INT)

IF LTRIM(RTRIM(@CD_FILIAL))<>''
BEGIN
INSERT INTO #_RS_FILIAL 						
SELECT @CD_EMP, 
	ID 
FROM 
	UFD_PRM_IN_STRING(@CD_FILIAL)
END
ELSE

BEGIN
	INSERT INTO #_RS_FILIAL 						
	SELECT 
		CD_EMP,
		CD_FILIAL
	FROM 
		PRC_FILIAL
	WHERE
		CD_EMP = @CD_EMP
END

CREATE TABLE #RsMovimento(CD_FILIAL				INT,
						 VLR_VENDA_LIQUIDA      MONEY,
						 QTDE_CUPONS_ITENS      MONEY,
						 VLR_DESC_VERBA      MONEY,
						 VLR_DESC_ITENS      MONEY,
						 VLR_OFERTA      MONEY,
						 VLR_DESC_TOT      MONEY,
						 VLR_VENDA_PMC       MONEY)

INSERT INTO #RsMovimento
	(CD_FILIAL,
	VLR_VENDA_LIQUIDA,
	VLR_DESC_VERBA,
	VLR_DESC_ITENS,
	VLR_OFERTA,
	VLR_DESC_TOT,
	VLR_VENDA_PMC)


--VALORES VENDA
SELECT 
	EST_MOVIMENTO_VENDAS.CD_FILIAL,
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ),2), 
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_VERBA),2),
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_ITENS),2),
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_OFERTA),2),
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_VERBA+EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_ITENS+EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_OFERTA),2) AS VLR_DESC_TOTAL,
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_PMC),2)
FROM            
	EST_MOVIMENTO_VENDAS_PRODUTOS INNER JOIN EST_MOVIMENTO_VENDAS ON
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_CTR_VENDAS = EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
	INNER JOIN GLB_DT_MOVIMENTO ON
	EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
	INNER JOIN #_RS_FILIAL f ON
	EST_MOVIMENTO_VENDAS.CD_FILIAL = f.CD_FILIAL
WHERE
	EST_MOVIMENTO_VENDAS.TIPO_VENDA IN (0,2,3,10,11)
	AND GLB_DT_MOVIMENTO.DT_MOVIMENTO BETWEEN @DT_INI AND @DT_FIM
GROUP BY EST_MOVIMENTO_VENDAS.CD_FILIAL


--RESULTADO DE DADOS
SELECT 
	CD_FILIAL AS CODIGO,
	VLR_VENDA_LIQUIDA AS VLR_VD_LIQ,
	VLR_DESC_VERBA AS VLR_DESC_VERBA,
	VLR_DESC_ITENS AS VLR_DESC_ITENS,
	VLR_OFERTA AS VLR_DESC_OFERTA,
	VLR_DESC_TOT AS VLR_TOT_DESC,
	VLR_VENDA_PMC AS VLR_VD_PMC
FROM 
	#RsMovimento m
ORDER BY CD_FILIAL
DROP TABLE #RsMovimento;	 	 
DROP TABLE #_RS_FILIAL;
GO


